/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.compat.waila.ICustomWailaDisplay;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockReinforcedSlabs2
extends BlockSlab
implements ITileEntityProvider,
ICustomWailaDisplay {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private final boolean isDouble;

    public BlockReinforcedSlabs2(boolean isDouble, Material blockMaterial) {
        super(blockMaterial);
        this.isDouble = isDouble;
        if (!this.func_176552_j()) {
            this.field_149783_u = true;
        }
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.RED_SANDSTONE)));
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return !(entity instanceof EntityWither);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)SCContent.reinforcedStoneSlabs2);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (!this.isDouble) {
            for (EnumType et : EnumType.values()) {
                list.add(new ItemStack(item, 1, et.getMetadata()));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)SCContent.reinforcedStoneSlabs2));
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a() + "." + EnumType.byMetadata(meta).getUnlocalizedName();
    }

    public IProperty<?> func_176551_l() {
        return VARIANT;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return EnumType.byMetadata(stack.func_77960_j() & 7);
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.byMetadata(meta & 7)));
        state = state.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int meta = b0 | ((EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
        if (state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            meta |= 8;
        }
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, VARIANT});
    }

    public boolean func_176552_j() {
        return this.isDouble;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityOwnable();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)state.func_177230_c()), 1, this.func_180651_a(state));
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        return new ItemStack(Item.func_150898_a((Block)SCContent.reinforcedStoneSlabs2), 1, BlockUtils.getBlockMeta(world, pos) % 8);
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return true;
    }

    public static enum EnumType implements IStringSerializable
    {
        RED_SANDSTONE(0, "red_sandstone"),
        PURPUR(1, "purpur");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;

        private EnumType(int meta, String name) {
            this(meta, name, name);
        }

        private EnumType(int meta, String name, String unlocalizedName) {
            this.meta = meta;
            this.name = name;
            this.unlocalizedName = unlocalizedName;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] values = EnumType.values();
            int length = values.length;
            for (int i = 0; i < length; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = values[i];
            }
        }
    }
}

